"use client"
import SvgColor from "@/shared/components/svg-color"
import {
  Dialog,
  DialogTitle,
  DialogContent,
  Divider,
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  IconButton,
  CircularProgress,
  Box,
} from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faClose } from '@fortawesome/free-solid-svg-icons';
import { AmendmentTripDTO } from "@/shared/types/ammendment-passenger"
import { PassengerInfo } from "@/shared/types/circuit"
import { useAmendmentPassengerStore } from "@/shared/api/stores/circuit-service/amendmentPassengerStore"
import { useEffect, useState } from "react"
import { enqueueSnackbar } from "notistack"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"
import { getLabel } from "@/shared/_mock"
import { _particularityTransportOptions } from "@/shared/sections/usager/utils/form-fields-usager"
import EmptyContent from "@/shared/components/empty-content"
import TransportScheduleTable from "@/shared/components/form/transport-schedule-table"

type UsagerDetailsDialogProps = {
  open: boolean
  onClose: () => void
  usager: PassengerInfo | null
}

export default function UsagerDetailsDialog({ open, onClose, usager }: UsagerDetailsDialogProps) {
  const [usagerDetails, setUsagerDetails] = useState<AmendmentTripDTO | null>(null)
  const { getAmendmentByPassengerId, loading } = useAmendmentPassengerStore()

  useEffect(() => {
    if (open && usager) {
      const fetchUsagerDetails = async () => {
        try {
          const details = await getAmendmentByPassengerId(usager.id)
          setUsagerDetails(details)
        } catch (error: any) {
          enqueueSnackbar(error.message || "Erreur lors de la récupération des détails de l'usager:", { variant: "error" })
        }
      }
      fetchUsagerDetails()
    }
  }, [open, usager, getAmendmentByPassengerId])

  if (!usager) return null

  return (
    <Dialog open={open} onClose={onClose} maxWidth="xl" fullWidth>
      <DialogTitle sx={{ color: "primary.main", m: 0, p: 2 }}>
        {usager.name}
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: "absolute",
            right: 8,
            top: 10,
            color: (theme) => theme.palette.grey[500],
          }}
        >
          <FontAwesome icon={faClose} width={18} />
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        <ConditionalComponent isValid={!loading} defaultComponent={
          <Box sx={{ display: "flex", justifyContent: "center", alignItems: "center", py: 4 }}>
            <CircularProgress />
          </Box>
        }>
          <>
            <List dense sx={{ p: 0 }}>
              <ListItem sx={{ p: 0 }}>
                <ListItemIcon sx={{ minWidth: "auto", mr: 2 }}>
                  <SvgColor
                    src="/assets/icons/menu/ic_exploitation.svg"
                    sx={{ color: "primary.main", width: 18, height: 18 }}
                  />
                </ListItemIcon>
                <ListItemText
                  primary={"Particularité du transport"}
                  secondary={getLabel(usagerDetails ? usagerDetails.particularityTransport : "", _particularityTransportOptions) || "Non spécifié"}
                  sx={{ m: 0 }}
                />
              </ListItem>
            </List>

            <Divider sx={{ my: 2 }} />
            <ConditionalComponent isValid={!!usagerDetails && usagerDetails.passengerScheduleWeeks && usagerDetails.passengerScheduleWeeks.length > 0}
              defaultComponent={
                <EmptyContent
                  filled
                  title="Aucun emploi du temps disponible"
                />
              }
            >
              <TransportScheduleTable
                title="Emploi du temps"
                amendmentData={usagerDetails!}
              />
            </ConditionalComponent>
          </>
        </ConditionalComponent>
      </DialogContent>
    </Dialog>
  )
}
