import React from 'react';
import { Circuit } from '@/shared/types/circuit';
import TableManager from '@/shared/components/table/table-manager';
import CircuitTableRow from '../view/circuit-table-row';
import { TableColumn } from '@/shared/types/common';
import { useCircuitStore } from '@/shared/api/stores/circuit-service/circuitStore';


interface CircuitTableProps {
  filteredData: Circuit[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleView: (item: Circuit) => void;
  totalCircuits: number;
}

export default function CircuitTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleView,
  totalCircuits,
}: CircuitTableProps) {
  const {loading} = useCircuitStore();
  const renderRow = (row: Circuit) => (
     <CircuitTableRow
          dense={table.dense}
          key={row.id}
          row={row}
          handleDetailsContract={handleView}
          columns={tableHead.slice(0, -1)}
        />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      loading={loading}
      count={totalCircuits}
    />
  );
}

