import { Circuit, CalculationType, CircuitState, SaveCircuit } from '@/shared/types/circuit';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { TableType } from '@/shared/types/common';

const initialData = {
  circuitState: CircuitState.CONTROLLED,
  circuitCode: '',
  timeTolerance: 120,
  titled: '',
  startDate: '', 
  endDate: '',   
  mainDriver: null,
  mainEstablishment: 0,
  observation: '',
  colorCode: '',
  calculationType: CalculationType.URBAN,
}

const circuitConfig: TabConfig<Circuit> = {
  type: TableType.Circuit,
  listTitle: 'Liste des circuits',
  newItemTitle: 'Nouveau circuit',
  initialData: initialData as Circuit,
  getItemCode: (circuit) => circuit.circuitCode,
};

export function useCircuitTabs() {
  return useTabsManager<Circuit>(circuitConfig);
}

