import * as Yup from 'yup';

export const circuitSchema = Yup.object().shape({
  circuitState: Yup.string().required('Le circuit est requis'),
  circuitCode: Yup.string().required('code circuit est requis'),
  titled: Yup.string().required('Intitule du circuit est requis'),
  mainEstablishment: Yup.number().required('L\'établissement principal est requis')
    .test('is-greater-than-zero', 'L\'établissement doit être valide', value => value !== undefined && value > 0),
  calculationType: Yup.string(),
  startDate: Yup.string().required('La date de début est requise'),
  endDate: Yup.string()
    .required('La date de fin est requise')
    .test(
      'is-after-start',
      'La date de fin doit être après la date de début',
      function (endDate) {
        const { startDate } = this.parent;
        return new Date(endDate) > new Date(startDate);
      }
    ),
  colorCode: Yup.string(),
  mainDriver: Yup.string().nullable(),
  observation: Yup.string().nullable(),
  contractId: Yup.string().nullable(),
});

export const driverAssignmentSchema = (circuitStartDate?: string) => Yup.object().shape({
  assignmentStartDate: Yup.string()
    .required('La date de début est requise')
    .test(
      'is-after-or-equal-circuit-start',
      'La date de début doit être égale ou postérieure à la date de début du circuit',
      function (value) {
        if (!value || !circuitStartDate) return true;
        const assignmentDate = new Date(value);
        const circuitDate = new Date(circuitStartDate);
        return assignmentDate >= circuitDate;
      }
    ),
  assignmentEndDate: Yup.string()
    .required('La date de fin est requise')
    .test(
      'is-after-start',
      'La date de fin doit être après la date de début',
      function (value) {
        const { assignmentStartDate } = this.parent;
        if (!value || !assignmentStartDate) return true;
        return new Date(value) >= new Date(assignmentStartDate);
      }
    ),
  weeklyAssignmentSchedule: Yup.array()
    .min(1, 'Au moins un jour doit être sélectionné')
    .required('Les jours sont requis'),
  driverId: Yup.string().required('Le chauffeur est requis'),
  observations: Yup.string().nullable(),
});