import { _TRAJET_DUREES } from "@/shared/_mock/_circuit";
import { calculationTypeOptions, Circuit, circuitStateOptions, ITripDriverAssignment, ITripDriverAssignmentDetails } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";
import { faHashtag, faStickyNote, faTag, faUser } from "@fortawesome/free-solid-svg-icons";

export interface Option {
  value: string;
  label: string;
}

export const getFormFieldsCircuit = (
  establishmentOptions: Option[],
  driverOptions: Option[],
  contractOptions: Option[] = [],
  lotOptions: Option[] = [],
  searchContracts: (query?: string) => void,
  searchEstablishments: (query?: string) => void
): FormFieldType<Circuit>[] => [
    {
      name: 'circuitState',
      label: 'État du circuit',
      type: 'select',
      options: circuitStateOptions,
    },
    {
      name: 'colorCode',
      label: 'Code couleur',
      type: 'color',
      placeholder: 'Choisissez une couleur',
      required: true,
    },
    {
      name: 'startDate',
      label: 'Date de début',
      type: 'date',
      required: true,
    },
    {
      name: 'endDate',
      label: 'Date de fin',
      type: 'date',
      required: true,
    },
    {
      name: 'calculationType',
      label: 'Type de calcul',
      type: 'select',
      options: calculationTypeOptions,
    },
    {
      name: 'mainEstablishment',
      label: 'Établissement principal',
      type: 'combobox',
      placeholder: 'Entrez un nom',
      required: true,
      options: establishmentOptions,
      hasAddEstablishmentModal : true , 
      onSearch: searchEstablishments,
    },
    {
      name: 'timeTolerance',
      label: 'Paramètres trajet',
      type: 'select',
      placeholder: 'Sélectionnez une durée',
      options: _TRAJET_DUREES,
    },
    {
      name: 'mainDriver',
      label: 'Chauffeurs',
      type: 'combobox',
      placeholder: 'Entrez un nom',
      options: driverOptions,
    },
    {
      name: 'contractId',
      label: 'Contrat',
      type: 'combobox',
      placeholder: 'Sélectionnez un contrat',
      options: contractOptions,
      onSearch: searchContracts,
      hasAddContractModal: true
    },
    {
      name: 'lotIds',
      label: 'N° de lot',
      type: 'multiple',
      placeholder: 'Aucun lot disponible',
      icon: faHashtag,
      options: lotOptions,
    },
    {
      name: 'observation',
      label: "Observation",
      placeholder: "Ajoutez une note ou une observation",
      type: 'textarea',
      icon: faStickyNote,
    },

  ];
export const getFormFieldsTripDriverAssignment = (tripOptions: Option[], driverOptions: Option[]): FormFieldType<ITripDriverAssignment>[] => [
  {
    name: 'assignmentStartDate',
    label: 'A partir du',
    required: true,
    type: 'date',
  },
  {
    name: 'assignmentEndDate',
    label: "Jusqu'au",
    type: 'date',
    required: true,
  },
  {
    name: 'weeklyAssignmentSchedule',
    label: "Jours Attribués",
    type: 'select',
  },
  {
    name: 'tripId',
    label: 'Trajet',
    type: 'multiple',
    placeholder: 'Sélectionnez un trajet',
    options: tripOptions,
  },
  {
    name: 'driverId',
    label: 'Chauffeur',
    placeholder: 'Entrez un nom',
    type: 'select',
    options: driverOptions,
    required: true,
  },
  {
    name: 'observations',
    label: "Observation",
    placeholder: "Ajoutez une note ou une observation",
    type: 'text',
    icon: faStickyNote,
  },
];

export const getFormFieldsTripDriverAssignmentDetails = (): FormFieldType<ITripDriverAssignmentDetails>[] => [
  {
    name: 'assignmentStartDate',
    label: 'A partir du',
    type: 'date',
  },
  {
    name: 'assignmentEndDate',
    label: "Jusqu'au",
    type: 'date',
  },
  {
    name: 'weeklyAssignmentSchedule',
    label: "Jours Attribués",
    type: 'select',
  },
  {
    name: 'tripTitled',
    label: 'Trajet',
    type: 'text',
    placeholder: 'Nom du trajet',
    icon: faTag
  },
  {
    name: 'driverName',
    label: 'Chauffeur',
    type: 'text',
    placeholder: 'Nom du chauffeur',
    icon: faUser,
  },

  {
    name: 'observations',
    label: "Observation",
    type: 'text',
    placeholder: 'Observations',
    icon: faStickyNote,
  },

];

export const formConfig: FormFieldType<Circuit>[] = [
  {
    name: 'circuitCode',
    label: 'Code Circuit',
    type: 'text',
    placeholder: '00',
    icon: faHashtag,
    required: true
  },
  {
    name: 'titled',
    label: 'Intitulé',
    type: 'text',
    placeholder: 'Entrez un nom',
    required: true
  },
]

export const getEtatColor = (status: string) => {
  switch (status) {
    case 'controle':
      return '#81919A';
    case 'non_controle':
      return '#eab308';
    default:
      return '#F9B90B';
  }
};
