import { WeekSchedule } from "@/shared/components/form/etablissement-jours-field"
import { WeekTypeSchedule } from "@/shared/types/circuit"

export const transformToWeekSchedule = (weekTypeSchedules: WeekTypeSchedule[] | undefined | null): WeekSchedule[] => {
  if (!Array.isArray(weekTypeSchedules)) return []
  return weekTypeSchedules.map((schedule) => ({
    id: "",
    weekType: schedule?.weekType ?? "",
    schedules: (schedule?.periods ?? []).map((period) => ({
      id: "",
      dayOfWeek: period.dayOfWeek,
      periodOfDay: period.periodOfDay,
    })),
  }))
}

export const transformFromWeekSchedule = (weekSchedules: WeekSchedule[] | undefined | null): WeekTypeSchedule[] => {
  if (!Array.isArray(weekSchedules)) return []
  return weekSchedules.map((schedule) => ({
    weekType: schedule.weekType,
    periods: (schedule.schedules ?? []).map((daySchedule) => ({
      dayOfWeek: daySchedule.dayOfWeek,
      periodOfDay: daySchedule.periodOfDay,
    })),
  }))
}