import { useEffect, useState } from "react";
import { useInfrastructureStore } from "@/shared/api/stores/admin-service/infrastructureStore";

export function useDepartmentOptions() {
  const [departmentOptions, setDepartmentOptions] = useState<{ label: string; value: string }[]>([]);
  const { departmentNames, fetchDepartmentNames } = useInfrastructureStore();

  useEffect(() => {
    fetchDepartmentNames();
  }, []);

  useEffect(() => {
    if (departmentNames.length > 0) {
      const options = departmentNames.map((department) => ({
        label: department.name,
        value: department.id.toString(),
      }));
      setDepartmentOptions(options);
    }
  }, [departmentNames]);

  return departmentOptions;
}
