import * as yup from 'yup';

export const clientSchema = yup.object().shape({

  civility: yup
    .string()
    .required("La civilité est requise"),

  firstName: yup.string().required("Le prénom est requis"),

  lastName: yup.string().required("Le nom est requis"),

  email: yup
    .string()
    .email("Email invalide")
    .required("L'email est requis"),

  personalEmail: yup
    .string()
    .nullable()
    .email("Email personnel invalide"),

  phoneNumber: yup
    .string()
    .matches(
      /^\+?[0-9]{10,}$/,
      "Le numéro de téléphone doit contenir au moins 10 chiffres et peut commencer par +"
    )
    .required("Le téléphone mobile est requis"),

  landlinePhone: yup
    .string()
    .nullable()
    .notRequired()
    .transform((value) => (value === '' ? null : value))
    .matches(
      /^\+?[0-9]{10,}$/,
      { message: "Le numéro de téléphone doit contenir au moins 10 chiffres et peut commencer par +", excludeEmptyString: true }
    ),

    siret: yup
    .string()
    .nullable()
    .notRequired()
    .transform((value) => (value === '' ? null : value))
    .matches(
      /^\d{14}$/,
      { message: "Le numéro SIRET doit être composé exactement de 14 chiffres", excludeEmptyString: true }
    ),

    tva: yup
    .string()
    .nullable()
    .notRequired()
    .transform((value) => (value === '' ? null : value))
    .matches(
      /^[A-Za-z0-9]{13}$/,
      { message: "Le numéro de TVA doit contenir exactement 13 lettres et/ou chiffres", excludeEmptyString: true }
    ),

  agency_id: yup.number().required("L'ID de l'agence est requis"),

  apeCode: yup
    .string()
    .matches(
      /^[A-Za-z0-9]{1,10}$/,
      "Le code APE doit contenir 1 lettre et 4 chiffres"
    )
    .notRequired()
    .nullable(),
  
  mapAdresse: yup.object().shape({
      address: yup.string().required("L'adresse est requise"),
      lat: yup.number(),
      lng: yup.number(),
      city: yup.string(),
      postalCode: yup.string(),
      country: yup.string(),
      formattedAddress: yup.string().required("L'adresse est requise")
    }),
    agencyName: yup.string(),
  
    auxiliaryAccount: yup
    .number()
    .typeError("Le compte auxiliaire doit être un nombre")
    .notRequired()
    .nullable(),
  
  salesAccount: yup
    .number()
    .typeError("Le compte de vente doit être un nombre")
    .notRequired()
    .nullable(),
  
  accountingAccount: yup
    .number()
    .typeError("Le compte comptable doit être un nombre")
    .notRequired()
    .nullable(),
});
