import { IClient } from "@/shared/types/client";
import type { FormFieldType } from "@/shared/types/common";
import {
  faUserTie,
  faHashtag,
  faPhone,
  faEnvelope,
  faMobileScreenButton,
  faLock,
  faNoteSticky,
  faMagnifyingGlassLocation,
} from "@fortawesome/free-solid-svg-icons";
import { _CIVILITE } from "../../usager/utils/form-fields-usager";
import { _BILLING_TERMS, _PORTAL_STATUS, _TYPE_STRUCT } from "@/shared/_mock/_client";
import { MainBranch, PortalAssignment } from "@/shared/types/client";
import { Civility } from "@/shared/types/common";

export const _TYPE_ADRESSE = [
  { value: "professionnel", label: "Professionnel" },
  { value: "personnelle", label: "Personnelle" },
];

export const formFields = (
  AgencyNames: { label: string; value: string }[],
  ClientTypes: { label: string; value: string }[],
  DepartmentOptions: { label: string; value: string }[]

): FormFieldType<IClient>[] => [
    {
      name: "civility",
      label: "Civilité",
      type: "checkbox",
      options: Object.keys(Civility).map(key => ({
        value: Civility[key as keyof typeof Civility],
        label: Civility[key as keyof typeof Civility],
      })),
    },
    {
      name: "firstName",
      label: "Prénom",
      placeholder: "Entrez un Nom",
      type: "text",
      required: true,
      icon: faUserTie,
    },
    {
      name: "lastName",
      label: "Nom",
      placeholder: "Entrez un Prénom",
      type: "text",
      required: true,
      icon: faUserTie,
    },
    {
      name: "agencyName",
      label: "Nom de la société",
      type: "select",
      placeholder: "choisissez votre entrprise",
      required: true,
      icon: '/assets/icons/form/ic_file_contrat.svg',
      options: AgencyNames,
      hasAddInfrastructureModal: true
    },
    {
      name: "department",
      label: "Département",
      type: "select",
      placeholder: "Sélectionnez un département",
      required: true,
      icon: '/assets/icons/form/ic_palette.svg',
      options: DepartmentOptions,
      hasAddInfrastructureModal: true
    },
    {
      name: "typeClient",
      label: "Type de client",
      type: "select",
      placeholder: "Choisissez le type",
      options: ClientTypes.map(type => ({
        value: type.value,
        label: type.label,
      })),
    },
    {
      name: "siret",
      label: "SIRET",
      type: "number",
      placeholder: "0000 000 000 000",
      icon: faHashtag,
    },
    {
      name: "tva",
      label: "Numéro de TVA",
      type: "number",
      placeholder: "0000 000 000 000",
      icon: faHashtag,
    },
    {
      name: "mapAdresse",
      label: "Adresse complète",
      type: "address",
      placeholder: "Saisissez une adresse",
      required: true,
      icon: faMagnifyingGlassLocation,


    },
    {
      name: "landlinePhone",
      label: "Téléphone fixe",
      type: "number",
      placeholder: "00000 000 000",
      icon: faPhone,
    },
    {
      name: "phoneNumber",
      label: "Téléphone mobile",
      type: "number",
      placeholder: "00000 000 000",
      required: true,
      icon: faMobileScreenButton,
    },
    {
      name: "iban",
      label: "IBAN",
      type: "text",
      placeholder: "FR76 XXXX XXXX XXXX XXXX XXXX X",
      icon: faHashtag,
    },
    {
      name: "apeCode",
      label: "Code APE",
      type: "number",
      placeholder: "APE Code",
      icon: faHashtag,
    },
    {
      name: "signatureDate",
      label: "Date de Signature",
      type: "date",
    },
    {
      name: "portalAssignment",
      label: "Attribution d'un Portail",
      type: "select",
      options: Object.keys(PortalAssignment).map(key => ({
        value: PortalAssignment[key as keyof typeof PortalAssignment],
        label: PortalAssignment[key as keyof typeof PortalAssignment],
      })),
    },
    {
      name: "bankName",
      label: "Banque",
      type: "text",
      placeholder: "Nom de la banque",
      icon: '/assets/icons/form/ic_building.svg',
    },
    {
      name: "mainBranch",
      label: "Branche mère",
      type: "select",
      options: Object.keys(MainBranch).map(key => ({
        value: MainBranch[key as keyof typeof MainBranch],
        label: MainBranch[key as keyof typeof MainBranch],
      })),
    },
    {
      name: "auxiliaryAccount",
      label: "Compte auxiliaire",
      type: "number",
      placeholder: "0000 000 000 000",
      icon: faHashtag,
    },
    {
      name: "colorCode",
      label: "Code couleur",
      type: "color",
      placeholder: "Choisissez une couleur",
      required: true,
      icon: '/assets/icons/form/ic_palette.svg',
    },
    {
      name: "personalEmail",
      label: "Email",
      type: "text",
      placeholder: "Entrez un email personnel",
      icon: faEnvelope,
    },
    {
      name: "email",
      label: "Email professionnel",
      type: "text",
      placeholder: "Entrez un email",
      required: true,
      icon: faEnvelope,
    },
    {
      name: "password",
      label: "Mot de passe",
      type: "password",
      placeholder: "**********",
      showPassword: true,
    },
    {
      name: "salesAccount",
      label: "Compte de Vente",
      type: "number",
      placeholder: "0000 000 000 000",
      icon: faHashtag,
    },
    {
      name: "accountingAccount",
      label: "Compte comptable",
      type: "number",
      placeholder: "0000 000 000 000",
      icon: faHashtag,
    },
    {
      name: "paymentDate",
      label: "Date de règlement",
      type: "date",
    },
    {
      name: "observation",
      label: "Observation",
      type: "textarea",
      placeholder: "Ajoutez une note ou une observation",
      icon: faNoteSticky,
    },
  ];
