import React from 'react';
import { ContractList } from '@/shared/types/contract';
import ContractTableRow from '../view/contract-table-row';
import TableManager from '../../../components/table/table-manager';
import { TableColumn } from '@/shared/types/common';

interface ContractTableProps {
  loading: boolean;
  filteredData: ContractList[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (contract: ContractList) => void;
  handleCopy: (contract: ContractList) => void;
  handleView: (contract: ContractList) => void;
  totalContracts: number;
  onPageChange: (event: React.MouseEvent<HTMLButtonElement> | null, page: number) => void;
  page: number;
  onRowsPerPageChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
  rowsPerPage: number;
  sortBy: string;
  sortDirection: 'asc' | 'desc';
}

export default function ContractTable({
  loading,
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleCopy,
  handleView,
  totalContracts,
  onPageChange,
  page,
  onRowsPerPageChange,
  rowsPerPage,
  sortBy,
  sortDirection
}: ContractTableProps) {
  const renderRow = (row: ContractList) => (
    <ContractTableRow
      key={row.id}
      row={row}
      handleEditContract={() => handleEdit(row)}
      handleCopyContract={() => handleCopy(row)}
      handleDetailsContract={() => handleView(row)}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
    />
  );

  return (
    <TableManager
      loading={loading}
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      onPageChange={onPageChange}
      page={page}
      onRowsPerPageChange={onRowsPerPageChange}
      rowsPerPage={rowsPerPage}
      count={totalContracts}
      sortBy={sortBy}
      sortDirection={sortDirection}
    />
  );
}
