import { Contract, ContractRequest, ContractList, ContractStatus } from '@/shared/types/contract';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';

const initialValues: ContractList = {
  id: '',
  title: '',
  contractCode: '',
  endDate: '',
  marketDate: '',
  renewalDate: '',
  marketNumber: '',
  agencyId: 0,
  agencyName: '',
  departmentId: 0,
  departmentName: '',
  lotNumber: '',
  clientId: 0,
  clientFullName: '',
  status: ContractStatus.NEW,
  contractColor: '',
  active: true,
};

const contractConfig: TabConfig<ContractList | Contract | ContractRequest> = {
  type: 'contract',
  listTitle: 'Liste des contrats',
  newItemTitle: 'Nouveau contrat',
  initialData: initialValues,
  getItemCode: (contract) => contract.title,
};

export function useContractTabs() {
  return useTabsManager<ContractList | Contract | ContractRequest>(contractConfig);
}

