import * as yup from 'yup';

export const contractSchema = yup.object().shape({
  title: yup.string().required('Le titre est requis'),
  contractCode: yup.string().optional().nullable(),
  startDate: yup.date().required('La date de début est requise'),
  endDate: yup.date()
    .required('La date de fin est requise')
    .min(yup.ref('startDate'), 'La date de fin doit être postérieure à la date de début'),
  marketDate: yup.date().optional().nullable(),
  renewalDate: yup.date().optional().nullable(),
  priceRevisionDate: yup.date().optional().nullable(),
  marketNumber: yup.string().optional().nullable(),
  status: yup.string().nullable().optional(),
  pricingGridType: yup.number().optional().nullable(),
  priceRevisionFrequencyMonths: yup.number().optional().nullable(),
  contractColor: yup.string().required('La couleur est requise'),
  contractualSubsets: yup.array().of(yup.string()),
  commitmentNumber: yup.string().optional().nullable(),
  contractDurationMonths: yup.number().optional().nullable(),
  renewalStatus: yup.string().optional().nullable(),
  tadType: yup.string().optional().nullable(),
  googleTADVisibility: yup.boolean(),
  orderNumber: yup.number().optional().nullable(),
  purchaseOrder: yup.number().optional().nullable(),
  agencyId: yup.number().required('L’agence est requise'),
  departmentId: yup.number().required('Le département est requis'),
  lotsId: yup.array().of(yup.number()).min(1, 'Au moins un lot est requis').required('Les lots sont requis'),
  clientId: yup.number().required('Le client est requis'),
  observation: yup.string().optional().nullable(),
});