import { FormFieldType } from '@/shared/types/common';
import { ContractRequest } from '@/shared/types/contract';
import { faUserTie, faBriefcase, faHashtag, faEuro, faNoteSticky } from '@fortawesome/free-solid-svg-icons';


export const formFields = (
  agencyOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[],
  lotOptions: { value: string; label: string }[],
  clientOptions: { value: string; label: string }[]
): FormFieldType<ContractRequest>[] => [
    {
      name: 'title',
      label: 'Nom du contrat',
      type: 'text',
      placeholder: 'Convention de partenariat',
      required: true,
      icon: '/assets/icons/form/ic_file_contrat.svg',
    },
    {
      name: 'contractCode',
      label: 'Code du contrat',
      type: 'text',
      placeholder: 'Code du contrat',
      icon: '/assets/icons/form/ic_file_contrat.svg',
    },
    {
      name: 'startDate',
      label: 'Date de début',
      type: 'date',
      required: true,
    },
    {
      name: 'endDate',
      label: 'Date de fin',
      type: 'date',
      required: true,
    },
    {
      name: 'renewalDate',
      label: 'Date de renouvellement',
      type: 'date',
    },
    {
      name: 'marketDate',
      label: 'Date du marché',
      type: 'date',
    },
    {
      name: 'clientId',
      label: 'Client',
      type: 'select',
      placeholder: 'Entrez un nom',
      required: true,
      icon: faUserTie,
      options: clientOptions,
      hasAddClientModal : true 
    },
    {
      name: 'departmentId',
      label: 'Département',
      type: 'select',
      placeholder: 'Entrez un nom',
      required: true,
      icon: faUserTie,
      options: departmentOptions,
    },
    {
      name: 'contractColor',
      label: 'Couleur de catégorisation',
      type: 'color',
      placeholder: 'Choisissez une couleur',
      required: true,
    },
    {
      name: 'agencyId',
      label: 'Agence',
      type: 'select',
      placeholder: 'Entrez un nom',
      required: true,
      icon: faBriefcase,
      options: agencyOptions,
    },
    {
      name: 'lotsId',
      label: 'Lots',
      type: 'multiple',
      placeholder: '0000 000 000 000',
      required: true,
      icon: faHashtag,
      options: lotOptions,
    },
    {
      name: 'pricingGridType',
      label: 'Grille de prix',
      type: 'text',
      placeholder: '0',
      icon: faEuro,
    },
    {
      name: 'priceRevisionDate',
      label: 'Date de révision des prix',
      type: 'date',
    },
    {
      name: 'priceRevisionFrequencyMonths',
      label: 'Fréquence (en mois)',
      type: 'text',
      placeholder: '0',
      icon: faHashtag,
    },
    {
      name: 'marketNumber',
      label: 'N° de marché',
      type: 'text',
      placeholder: '0000 000 000 000',
      icon: faHashtag,
    },
    {
      name: 'commitmentNumber',
      label: 'N° d\'engagement',
      type: 'text',
      placeholder: '0000 000 000 000',
      icon: faHashtag,
    },
    {
      name: 'contractDurationMonths',
      label: 'Durée du marché (en mois)',
      type: 'text',
      placeholder: '0',
      icon: faHashtag,
    },
    {
      name: 'renewalStatus',
      label: 'Reconduction',
      type: 'select',
      options: [
        { value: 'true', label: 'Oui' },
        { value: 'false', label: 'Non' },
      ],
    },
    {
      name: 'tadType',
      label: 'Type de contrat TAD',
      type: 'select',
      options: [
        { value: 'true', label: 'Oui' },
        { value: 'false', label: 'Non' },
      ],
    },
    {
      name: "observation",
      label: "Observation",
      type: "textarea",
      placeholder: "Ajoutez une note ou une observation",
      icon: faNoteSticky
    },
  ];

export type ContratType = {
  numero: string;
  code: string;
  nom: string;
  trajetAller: string;
  trajetRetour: string;
  tarifAller: string;
  tarifRetour: string;
  tarifTotal: string;
};

export const HEAD_CELLS: { id: keyof ContratType; label: string; align?: 'left' | 'center' }[] = [
  { id: 'numero', label: 'Numéro de Circuit', align: 'center' },
  { id: 'code', label: 'Code de Circuit', align: 'center' },
  { id: 'nom', label: 'Nom du Circuit', align: 'left' },
  { id: 'trajetAller', label: 'Trajet Aller', align: 'left' },
  { id: 'trajetRetour', label: 'Trajet Retour', align: 'left' },
  { id: 'tarifAller', label: 'Tarif Aller', align: 'center' },
  { id: 'tarifRetour', label: 'Tarif Retour', align: 'center' },
  { id: 'tarifTotal', label: 'Tarif Total', align: 'center' },
];
