import { FormFieldType } from '@/shared/types/common';
import {
  faHashtag,
  faMobileScreenButton,
  faEnvelope,
  faGlobe,
  faFax,
  faStickyNote,
  faUserTie,
} from '@fortawesome/free-solid-svg-icons';
import { CIVILITY_OPTIONS, ESTABLISHMENT_SECTOR_OPTIONS, ESTABLISHMENT_TYPE_OPTIONS, EstablishmentRequest, EstablishmentManager } from '@/shared/types/establishment';


export const mainEtabformFields = (): FormFieldType<EstablishmentRequest>[] => [
  {
    name: 'establishmentCode',
    label: "Code de l'établissement",
    placeholder: 'Entrez un code',
    type: 'text',
    icon: faHashtag,
  },
  {
    name: 'establishmentName',
    label: "Nom de l'établissement",
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: '/assets/icons/form/ic_building.svg',
  },
  {
    name: 'uaiCode',
    label: 'Code UAI',
    type: 'text',
    placeholder: 'Entrez le code UAI',
    icon: faHashtag,
  },
];

export const detailsEtabformFields = (
  zoneOptions: { label: string, value: string }[],
  departmentOptions: { label: string, value: string }[],
): FormFieldType<EstablishmentRequest>[] => [
    {
      name: 'establishmentSector',
      label: 'Regime',
      type: 'select',
      options: ESTABLISHMENT_SECTOR_OPTIONS,
    },
    {
      name: 'mapAddress',
      label: 'Adresse',
      type: 'address',
      required: true,
      placeholder: 'Choisissez une adresse',
    },
    {
      name: 'phoneNumber',
      label: 'Téléphone',
      type: 'text',
      placeholder: '00000 000 000',
      icon: faMobileScreenButton,
    },
    {
      name: 'departmentId',
      label: 'Département',
      type: 'select',
      required: true,
      options: departmentOptions,
      hasAddInfrastructureModal : true 
    },
    {
      name: 'colorCode',
      label: 'Code couleur',
      type: 'color',
      placeholder: 'Choisissez une couleur',
      icon: '/assets/icons/form/ic_palette.svg',
    },
    {
      name: "zoneId",
      label: "Zone scolaire",
      type: "select",
      required: true,
      options: zoneOptions,
    },
    {
      name: 'fax',
      label: 'Fax',
      type: 'text',
      placeholder: '00000 000 000',
      icon: faFax,
    },
    {
      name: 'email',
      label: 'Email',
      type: 'text',
      placeholder: 'Saisissez un email',
      required: true,
      icon: faEnvelope,
    },
    {
      name: 'website',
      label: 'Site web',
      type: 'text',
      placeholder: 'Saisissez un lien',
      icon: faGlobe,
    },
    {
      name: 'doId',
      label: 'ID du Do',
      placeholder: '0000 000 000 000',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'doCode',
      label: 'Code DO',
      placeholder: 'Saisissez doCode',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'establishmentType',
      label: 'Type',
      type: 'select',
      options: ESTABLISHMENT_TYPE_OPTIONS,
    },
    {
      name: 'academy',
      label: 'Académie',
      type: 'text',
      placeholder: 'Entrez une académie'
    },
  ];
export const observationformFields: FormFieldType<EstablishmentRequest>[] = [
  {
    name: 'observation',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
];
export const  responsableEtabformFields: FormFieldType<EstablishmentManager>[] = [
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    options: CIVILITY_OPTIONS,
  },
  {
    name: 'lastName',
    label: 'Nom du responsable',
    placeholder: 'Entrez un Nom',
    type: 'text',
    icon: faUserTie,
  },
  {
    name: 'firstName',
    label: 'Prénom du responsable',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    icon: faUserTie,
  },
  {
    name: 'personalEmail',
    label: 'Email',
    type: 'text',
    placeholder: 'Entrez un email',
    icon: faEnvelope,
  },
  {
    name: 'phoneNumber',
    label: 'Téléphone mobile',
    type: 'text',
    placeholder: '00000 000 000',
    icon: faMobileScreenButton,
  },
];