import * as Yup from 'yup';
import { EstablishmentSector, EstablishmentType } from '@/shared/types/establishment';

export const establishmentSchema = Yup.object().shape({
  establishmentName: Yup.string().required('Le nom de l\'établissement est requis'),
  establishmentCode: Yup.string().nullable(),
  uaiCode: Yup.string().nullable(),
  establishmentSector: Yup.string().oneOf(Object.values(EstablishmentSector)).nullable(),
  establishmentType: Yup.string().oneOf(Object.values(EstablishmentType)).nullable(),
  mondayMorningOpeningTime: Yup.string().nullable(),
  mondayEveningClosingTime: Yup.string().nullable(),
  tuesdayMorningOpeningTime: Yup.string().nullable(),
  tuesdayEveningClosingTime: Yup.string().nullable(),
  wednesdayMorningOpeningTime: Yup.string().nullable(),
  wednesdayEveningClosingTime: Yup.string().nullable(),
  thursdayMorningOpeningTime: Yup.string().nullable(),
  thursdayEveningClosingTime: Yup.string().nullable(),
  fridayMorningOpeningTime: Yup.string().nullable(),
  fridayEveningClosingTime: Yup.string().nullable(),
  saturdayMorningOpeningTime: Yup.string().nullable(),
  saturdayEveningClosingTime: Yup.string().nullable(),
  sundayMorningOpeningTime: Yup.string().nullable(),
  sundayEveningClosingTime: Yup.string().nullable(),
  mapAddress: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
    placeId: Yup.string(),
    formattedAddress: Yup.string(),
    city: Yup.string(),
    postalCode: Yup.string(),
    country: Yup.string(),
  }),
  phoneNumber: Yup.string().nullable(),
  colorCode: Yup.string().required('La couleur est requise'),
  fax: Yup.string().nullable(),
  email: Yup.string().email('Email invalide').required('L\'email est requis'),
  website: Yup.string().url('URL invalide').nullable(),
  doId: Yup.string().nullable(),
  doCode: Yup.string().nullable(),
  departmentId: Yup.string().required('Le département est requis'),
  zoneId: Yup.string().required('La zone scolaire est requis'),
  establishmentManager: Yup.object().shape({
    civility: Yup.string().nullable(),
    firstName: Yup.string().nullable(),
    lastName: Yup.string().nullable(),
    phoneNumber: Yup.string().nullable(),
    personalEmail: Yup.string().email('Email invalide').nullable(),
  }).nullable(),
  observation: Yup.string().nullable(),
  academy: Yup.string().nullable(),
  active: Yup.boolean().nullable(),
});