import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { TableType } from '@/shared/types/common';
import { IHolidayImport } from '@/shared/types/establishment';

export const DEFAULT_HOLIDAY_IMPORT : IHolidayImport = {
  id: "",
  holidayImportName: "",
  createdAt: "",
  importedBy: "",
  zones: [],
}

const holidayImportTabsConfig: TabConfig<IHolidayImport> = {
  type: TableType.Vacance,
  listTitle: "Liste vacances/Jours fériés",
  newItemTitle: "Nouvelle période",
  initialData: DEFAULT_HOLIDAY_IMPORT,
  getItemCode: (holidayImport) => holidayImport.id,
}

export function useHolidayImportTabs() {
  return useTabsManager<IHolidayImport>(holidayImportTabsConfig);
}