import { FormFieldType } from '@/shared/types/common';
import { AgencyRequest } from '@/shared/types/infrastructure';
import { faBuilding, faFile, faMapLocation } from '@fortawesome/free-solid-svg-icons';

export const mainAgencyFormFields = (sectorOptions: { value: string, label: string }[]): FormFieldType<AgencyRequest>[] => [
    {
        name: 'sectorId',
        label: "Secteur",
        placeholder: "Choisissez un secteur",
        options: sectorOptions,
        type: 'combobox',
        required: true
    },
    {
        name: 'name',
        label: "Nom d'agence",
        required: true,
        placeholder: 'Entrez un nom',
        icon: faBuilding,
        type: 'text',
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez une adresse',
        icon: faMapLocation,
        type: 'address',
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        icon: faFile,
        type: 'textarea',
    }
];

export const mainAgencyConsultFormFields = (sectorOptions: { value: string, label: string }[]): FormFieldType<AgencyRequest>[] => [
    {
        name: 'name',
        label: "Nom d'agence",
        required: true,
        placeholder: 'Entrez un nom',
        icon: faBuilding,
        type: 'text',
    },
    {
        name: 'sectorId',
        label: "Nom de secteur",
        placeholder: 'Choisissez un nom',
        type: 'select',
        options: sectorOptions,
        icon: faFile,
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez une adresse',
        icon: faMapLocation,
        type: 'address',
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        icon: faFile,
        type: 'textarea',
    }
];
