import { FormFieldType } from '@/shared/types/common';
import { DepartmentRequest } from '@/shared/types/infrastructure';
import { faBuilding, faMapLocation, faFile, faCode } from '@fortawesome/free-solid-svg-icons';

export const mainDepartmentFormFields = (
    agencyOptions: { label: string, value: string }[],
    zoneOptions: { label: string, value: string }[]
): FormFieldType<DepartmentRequest>[] => [
    {
        name: 'agencyId',
        label: "Agence",
        placeholder: 'Choisissez une agence',
        type: 'combobox',
        options: agencyOptions,
        icon: faFile,
        required: true
    },
    {
        name: 'name',
        label: 'Nom du département',
        placeholder: 'Entrez un nom',
        type: 'text',
        required: true,
        icon: faBuilding,
    },
    {
        name: 'code',
        label: 'Code du département',
        placeholder: 'Entrez un code',
        type: 'text',
        required: true,
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez un texte',
        type: 'address',
        icon: faMapLocation,
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        type: 'textarea',
        icon: faFile,
    },
    {
        name: 'hexColor',
        label: 'Couleur du département',
        placeholder: 'Choisissez une couleur',
        type: 'text',
        required: true,
    },
    {
        name: 'zoneId',
        label: 'Zone',
        placeholder: 'Choisissez une zone',
        type: 'combobox',
        options: zoneOptions,
        required: true
    }
];

export const mainDepartmentConsultFormFields = (): FormFieldType<DepartmentRequest>[] => [
    {
        name: 'name',
        label: 'Nom du département',
        placeholder: 'Entrez un nom',
        type: 'text',
        required: true,
        icon: faBuilding,
    },
    {
        name: 'code',
        label: 'Code du département',
        placeholder: 'Entrez un code',
        type: 'text',
        required: true,
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez un texte',
        type: 'address',
        icon: faMapLocation,
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        type: 'textarea',
        icon: faFile,
    },
];