import * as yup from 'yup';

export const departmentSchema = yup.object().shape({
  agencyId: yup.string().required('L\'agence est requise'),
  name: yup.string().required('Le nom est requis'),
  code: yup.string().min(3, 'Le code doit contenir exactement 3 caractères').max(3, 'Le code doit contenir exactement 3 caractères').required('Le code est requis'),
  mapAdresse: yup.object().shape({
    address: yup.string(),
    lat: yup.number(),
    lng: yup.number(),
    country: yup.string(),
    city: yup.string(),
    postalCode: yup.string(),
    formattedAddress: yup.string()
  }).optional().nullable(),
  description: yup.string().optional().nullable(),
  hexColor: yup.string().required('La couleur est requise'),
  zoneId: yup.string().required('La zone est requise')
});