import { FormFieldType } from '@/shared/types/common';
import { LotRequest } from '@/shared/types/infrastructure';
import { faMapPin, faHashtag, faFile } from '@fortawesome/free-solid-svg-icons';

export const mainLotFormFields = (departementOptions: { value: string; label: string }[]): FormFieldType<LotRequest>[] => [
  {
    name: 'departmentsIds',
    label: 'Départements',
    placeholder: 'Choisissez département',
    options: departementOptions,
    type: 'combobox-multiple',
    required: true,
    icon: faMapPin,
  },
  {
    name: 'number',
    label: 'Numéro de lot',
    placeholder: 'Entrez un numéro de lot',
    type: 'text',
    icon: faHashtag,
    required: true
  },
  {
    name: 'description',
    label: 'Description',
    placeholder: 'Écrivez un texte ici',
    type: 'textarea',
    icon: faFile,
  },
];

export const mainLotConsultFormFields: FormFieldType<LotRequest>[] = [
  {
    name: 'number',
    label: 'Numéro de lot',
    placeholder: 'Entrez un numéro de lot',
    type: 'text',
    icon: faHashtag,
  },
  {
    name: 'description',
    label: 'Description',
    placeholder: 'Écrivez un texte ici',
    type: 'textarea',
    icon: faFile,
  },
];