import { useMemo } from "react"
import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import { DEFAULT_EXPORT_TABLE_HEAD } from "@/shared/_mock/_export"
import { IExport } from "@/shared/types/export"

export function useExportTable(externalData?: IExport[]) {
  const exportConfig: TableConfig<IExport> = useMemo(() => ({
    initialData: externalData || [],
    defaultTableHead: DEFAULT_EXPORT_TABLE_HEAD,
  }), [externalData])

  return useTableManager<IExport>(exportConfig)
}
