export const ELEMENT_MICROSERVICE_MAPPING: Record<string, string> = {
  // User Service
  "Client": "user-service",
  "Contrat": "admin-service",
  "Etablissement": "admin-service",
  "Usagers": "user-service",
  "Absence usager": "user-service",
  "Chauffeur": "user-service",
  "Agent": "user-service",
  "Rôle": "user-service",
  "Equipe": "user-service",

  // Circuit Service
  "Circuit": "circuit-service",
  "Trajet": "circuit-service",
  "Avenant": "circuit-service",

  // Fleet Service
  "Parc véhicule": "fleet-service",
  "Marque / Modèle": "fleet-service",
  "Suivi kilométrage": "fleet-service",
  "Pétrolier": "fleet-service",
  "Suivi de carte": "fleet-service",
  "Frais carburant": "fleet-service",
  "Suivi carburant": "fleet-service",
  "Attribution / Restitution": "fleet-service",
  "Anomalie traitée": "fleet-service",
  "Bilan carbone": "fleet-service",
  "Liste fournisseur": "fleet-service",
  "Révision / Entretien": "fleet-service",
  "Réparation": "fleet-service",
  "Accident / Sinistre": "fleet-service",
  "Document flotte": "fleet-service",

  // HR Service
  "Absence": "hr-service",
  "Vacances / Jours fériés": "hr-service",
  "Feuille de présence": "hr-service",
  "Candidature chauffeur": "hr-service",
  "Candidature sédentaire": "hr-service",
  "Besoin recrutement": "hr-service",
  "Formulaire": "hr-service",
  "Salarié": "hr-service",
  "Congé": "hr-service",
  "Gestion d'absence / Congé": "hr-service",

  // Planning Service
  "Suivi trajet": "planning-service",
  "Préparation usager": "planning-service",
  "Préparation circuit": "planning-service",
  "Préparation chauffeur": "planning-service",

  // Roadsheet Service
  "Liste feuille de route": "roadsheet-service",
  "Envoi feuille de route": "roadsheet-service",
  "Feuille de route soumise": "roadsheet-service",

  // Admin Service
  "Infrastructure": "admin-service",
  "Gestion Email": "admin-service",
  "Gestion Notification": "admin-service",
  "Historique des emails": "admin-service",

  // Document Service
  "Document": "document-service",
}

export const getElementMicroservice = (elementLabel: string): string | null => {
  return ELEMENT_MICROSERVICE_MAPPING[elementLabel] || null
}
