import React from 'react';
import { Grid, Box } from '@mui/material';
import { FormikProps } from 'formik';
import { FormFieldType, ModeType, TableColumn } from '@/shared/types/common';
import { FuelSupplierRequestDTO } from '@/shared/types/fleet-management/fuelSupplier';
import ActionButtons from '@/shared/components/form/buttons-action';

interface FuelSupplierTabProps {
  renderField: (field: FormFieldType<FuelSupplierRequestDTO>) => React.ReactNode;
  baseFields: FormFieldType<FuelSupplierRequestDTO>[];
  isReadOnly: boolean;
  formik: FormikProps<FuelSupplierRequestDTO>;
  onEdit: (updatedFuelSupplier: FuelSupplierRequestDTO) => void;
  onSave: () => void;
  onClose: (isSaved: boolean) => void;
  tableHead: TableColumn[];
  mode: ModeType;
}

export default function FuelSupplierTab({
  renderField,
  baseFields,
  isReadOnly,
  formik,
  onEdit,
  onSave,
  onClose,
  tableHead,
  mode,
}: FuelSupplierTabProps) {


  return (
    <Box sx={{ p: 3 }}>
      <Grid container spacing={3}>
        {baseFields.map((field, index) => (
          <Grid item xs={12} md={field.type === 'textarea' ? 12 : 6} key={index}>
            {renderField(field)}
          </Grid>
        ))}
      </Grid>

      <ActionButtons
        mode={mode}
        onSave={onSave}
        onCancel={() => onClose(false)}
      />
    </Box>
  );
}