"use client"

import React from "react"
import { Typography, Box, IconButton } from "@mui/material"
import { ScrollBox } from "@/shared/theme/css"
import CustomDrawer from "@/shared/components/drawer/custom-drawer"
import FontAwesome from "@/shared/components/fontawesome"
import { faTimes } from "@fortawesome/free-solid-svg-icons"
import FuelTypeTable from "../../fuelType/views/fuel-type-table"
import { useResponsive } from "@/hooks"

type Props = {
  isOpen: boolean
  onClose: () => void
}

export default function FuelTypeSidebar({ isOpen, onClose }: Props) {

  const DRAWER_WIDTH = useResponsive("down", "lg") ? 600 : 800;

  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen} onClose={onClose}>
      <Box sx={{
        display: "flex",
        justifyContent: "space-between",
        alignItems: "center",
        p: 2,
        backgroundColor: "primary.main",
        color: "white"
      }}>
        <Typography
          variant="h5"
          sx={{
            fontWeight: 600,
          }}
        >
          Gestion des Types de Carburant
        </Typography>
        <IconButton
          onClick={onClose}
          sx={{
            color: "white",
            "&:hover": {
              backgroundColor: "primary.dark"
            }
          }}
        >
          <FontAwesome icon={faTimes} />
        </IconButton>
      </Box>

      <ScrollBox sx={{ maxHeight: "calc(100vh - 80px)", p: 2 }}>
        <Box sx={{ mb: 2 }}>
          <Typography
            variant="body1"
            sx={{
              color: "text.secondary",
              fontSize: "0.9rem",
            }}
          >
            Gérez les types de carburant disponibles dans le système.
            Vous pouvez activer/désactiver les types et modifier leurs informations.
          </Typography>
        </Box>

        <FuelTypeTable />
      </ScrollBox>
    </CustomDrawer>
  )
}