import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { FuelSupplier, FuelSupplierRequestDTO } from '@/shared/types/fleet-management/fuelSupplier';

const INITIAL_FUEL_SUPPLIER_DATA: FuelSupplier = {
  id: "",
  supplierName: "",
  fuelType: {
    id: "",
    name: "",
    active: true
  },
  observation: "",
  active: true,
}

const fuelSupplierConfig: TabConfig<FuelSupplier | FuelSupplierRequestDTO> = {
  type: 'pétrolier',
  listTitle: 'Liste des pétroliers',
  newItemTitle: 'Nouveau pétrolier',
  initialData: INITIAL_FUEL_SUPPLIER_DATA,
  getItemCode: (fuelSupplier) => fuelSupplier.supplierName,
};

export function useFuelSupplierTabs() {
  return useTabsManager<FuelSupplier | FuelSupplierRequestDTO>(fuelSupplierConfig);
}