import { FormFieldType } from "@/shared/types/common"
import {
  faGasPump,
  faNoteSticky,
  faTachometerAlt,
  faTag,
  faTags,
  faToggleOn,
} from "@fortawesome/free-solid-svg-icons"
import { FuelSupplierRequestDTO } from "@/shared/types/fleet-management/fuelSupplier"
import { IFuelHistory } from "@/shared/types/flottes/fuelImport";

export const fuelSupplierFormFields = (
  fuelTypeOptions: { value: string; label: string }[],
): FormFieldType<FuelSupplierRequestDTO>[] => [
  {
    name: 'supplierName',
    label: 'Nom du pétrolier',
    type: 'text',
    placeholder: 'Entrez le nom du pétrolier',
    icon: faTag,
    required: true
  },
  {
    name: 'fuelTypeId',
    label: 'Type de carburant',
    type: 'select',
    options: fuelTypeOptions,
    placeholder: 'Choisissez un type de carburant',
    icon: faGasPump,
    required: true
  },
  {
    name: 'observation',
    label: 'Observation',
    type: 'textarea',
    placeholder: 'Ajoutez une note ou une observation',
    icon: faNoteSticky,
  },
  {
    name: 'isActive',
    label: 'Actif',
    type: 'switch',
    icon: faToggleOn,
  },
]
export const fuelHistoryFormFields: FormFieldType<IFuelHistory>[] = [
  {
    name: "providerType",
    label: "Pétrolier",
    type: "text",
    required: true,
    icon: faTags
  },
  {
    name: "registrationDate",
    label: "Date d'enregistrement",
    type: "date",
  },
  {
    name: "kilometer",
    label: "Kilométrage",
    type: "text",
    icon: faTachometerAlt
  }
]
