import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { FuelType } from "@/shared/types/fleet-management/fuelType"

export const INITIAL_FUEL_TYPE_DATA: FuelType = {
  id: "",
  name: "",
  active: true,
}

const fuelTypeConfig: TabConfig<FuelType> = {
  type: "type de carburant",
  listTitle: "Liste des types de carburant",
  newItemTitle: "Nouveau type de carburant",
  initialData: INITIAL_FUEL_TYPE_DATA,
  getItemCode: (fuelType) => fuelType.name,
}

export function useFuelTypeTabs() {
  return useTabsManager<FuelType>(fuelTypeConfig)
}