import React from 'react';
import TableCell from '@mui/material/TableCell';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { ICircuitDriverAssignment } from '@/shared/types/flottes/vehicle-affectation';

type Props = {
  row: ICircuitDriverAssignment;
  dense: boolean;
  columns: TableColumn[];
};

export default function CircuitDriverRow({
  row,
  dense,
  columns,
}: Props) {

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'assignmentDate':
        return formatDate(value, dateFormat.isoDate);
      default:
        return value;
    }
  };


  return (
          <TrajetStyledRow
            key={row.id}
            style={{ cursor: 'pointer' }}
          >
            {columns.map((column: any) => (
              <TableCell
                key={column.id}
                align={column.align || 'left'}
                sx={{ whiteSpace: 'nowrap', py: column.id === 'etat' ? 0.2 : dense ? 0.5 : 1 }}
              >
                {renderCellContent(column.id, row[column.id as keyof ICircuitDriverAssignment])}
              </TableCell>
            ))}
          </TrajetStyledRow>
        );
      };
  

