'use client';

import React from 'react';
import { Box, IconButton, Stack } from '@mui/material';
import { TableType } from '@/shared/types/common';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import FontAwesome from '@/shared/components/fontawesome';
import { faRotate } from '@fortawesome/free-solid-svg-icons';
import { iconButtonStyles } from '@/shared/theme/css';
import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import TableManager from '@/shared/components/table/table-manager';

import ExportButton from '@/shared/components/table/table-export-button';
import { _circuitDriverAssignments, DEFAULT_CIRCUIT_DRIVER_ASSIGNMENT_TABLE_HEAD } from '@/shared/_mock/flottes/_affectation';
import CircuitDriverRow from './circuit-driver-row';
import { ICircuitDriverAssignment } from '@/shared/types/flottes/vehicle-affectation';

const chauffeurTableConfig: TableConfig<ICircuitDriverAssignment> = {
    initialData: _circuitDriverAssignments,
    defaultTableHead: DEFAULT_CIRCUIT_DRIVER_ASSIGNMENT_TABLE_HEAD,
};

export default function CircuitDriverAssignmentList() {

    const {
        table,
        filteredData,
        filters,
        tableHead,
        notFound,
        handleFilterChange,
        handleResetFilters,
        dataToExport,
    } = useTableManager<ICircuitDriverAssignment>(chauffeurTableConfig);
    const renderRow = (row: ICircuitDriverAssignment) => (
        <CircuitDriverRow
            dense={table.dense}
            key={row.id}
            row={row}
            columns={tableHead}
        />
    );

    return (
        <Box>
            <Stack direction="row" alignItems="center" justifyContent="flex-end" gap="8px" pb={2}>
                <>
                    <CustomTooltip title="Refresh" arrow>
                        <IconButton onClick={handleResetFilters} sx={iconButtonStyles}>
                            <FontAwesome icon={faRotate} width={16} />
                        </IconButton>
                    </CustomTooltip>

                    <ExportButton
                        tooltipTitle={"Exporter"}
                        type={TableType.Chauffeur}
                        filteredData={dataToExport}
                        tableHead={tableHead}
                    />
                </>

            </Stack>

            <TableManager
                filteredData={filteredData}
                table={table}
                tableHead={tableHead}
                notFound={notFound}
                filters={filters}
                onFilterChange={handleFilterChange}
                renderRow={renderRow}
                sx={{ backgroundColor: 'primary.lighter' }}
                isWithoutTabs
            />
        </Box>
    );
}
