import React from 'react';
import TableCell from '@mui/material/TableCell';
import { TableColumn } from '@/shared/types/common';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { dateFormat, formatDate } from '@/utils/format-time';
import { AssignmentHistory } from '@/shared/types/flottes/vehicle-affectation';

export type HistoryAssignmentRowProps = {
  handleDetails: (row: AssignmentHistory) => void;
  row: AssignmentHistory;
  dense: boolean;
  columns: TableColumn[];
};

const renderCellContent = (columnId: string, value: any) => {
  switch (columnId) {
    case 'dateAttribution':
    case 'endAttributionDate':
    case 'dateRestitution':
      return formatDate(value, dateFormat.isoDate);
    default:
      return value;
  }
};

export default function HistoryAssignmentRow({handleDetails, row, dense, columns }: HistoryAssignmentRowProps) {
  return (
    <TrajetStyledRow key={row.id} style={{ cursor: 'pointer' }}>
      {columns.map((column) => (
        <TableCell
          onDoubleClick={() => handleDetails(row)}
          key={column.id}
          align={column.align || 'left'}
          sx={{ whiteSpace: 'nowrap', py: dense ? 0.5 : 1 }}
        >
          {renderCellContent(column.id, row[column.id as keyof AssignmentHistory])}
        </TableCell>
      ))}
    </TrajetStyledRow>
  );
} 