import { TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_AFFECTATION_DATA } from "@/shared/_mock/flottes/_affectation"
import { IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation"

const affectationConfig: TabConfig<IVehicleAffectation> = {
  type: "attribution / restitution",
  listTitle: "Liste des attributions / restitutions",
  newItemTitle: "Nouvelle attribution / restitution",
  initialData: INITIAL_AFFECTATION_DATA,
  getItemCode: (affectation) => affectation.id,
}

export function useAffectationTabs() {
  return useTabsManager<IVehicleAffectation>(affectationConfig)
}

