import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_HISTORY_ASSIGNMENT_DATA } from '@/shared/_mock/flottes/_affectation';
import { AssignmentHistory } from '@/shared/types/flottes/vehicle-affectation';

const historyAssignmentTabConfig: TabConfig<AssignmentHistory> = {
  type: 'historique attribution',
  listTitle: 'Liste des historiques d\'attributions',
  newItemTitle: 'Nouvelle attribution',
  initialData: INITIAL_HISTORY_ASSIGNMENT_DATA,
  getItemCode: (item) => item.numeroImmatriculation,
};

export function useAssignmentHistoryTabs() {
  return useTabsManager<AssignmentHistory>(historyAssignmentTabConfig);
} 