import { _MODELES, IMMATRICULATIONS } from "@/shared/_mock";
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver";
import { FormFieldType } from "@/shared/types/common";
import { IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation";
import { faUser, faIdBadge, faCar, faBuilding, faBus, faTruck, faCheckCircle, faHashtag, faMap } from '@fortawesome/free-solid-svg-icons';
import { AssignmentHistory } from "@/shared/types/flottes/vehicle-affectation";

export const personnelFields: FormFieldType<IVehicleAffectation>[] = [
  {
    name: "personnelType",
    label: "Type de personnel",
    type: "select",
    required: true,
    options: [
      { value: "chauffeur", label: "Chauffeur" },
      { value: "sedentaire", label: "Sédentaire" },
    ],
    placeholder: "Choisissez le type de personnel",
    icon: faUser,
  },
  {
    name: "nomPersonnel",
    label: "Nom du personnel",
    type: "combobox",
    required: true,
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })), // À adapter si sédentaire
    placeholder: "Choisissez le personnel",
    icon: faIdBadge,
  },
  {
    name: "adressePersonnel",
    label: "Adresse du personnel",
    type: "address",
  },
];

export const vehiculeFields: FormFieldType<AssignmentHistory>[] = [
  {
    name: "secteur",
    label: "Secteur",
    type: "text",
    required: false,
    icon: faMap,
  },
  {
    name: "typeVehicule",
    label: "Type de véhicule",
    type: "combobox",
    required: true,
    options: [
      { value: "5 places", label: "5 places" },
      { value: "7 places", label: "7 places" },
    ],
    placeholder: "Choisissez le type de véhicule",
    icon: faCar,
  },
  {
    name: "numeroImmatriculation",
    label: "Immatriculation",
    type: "combobox",
    required: true,
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Choisissez un véhicule",
  },
  {
    name: "dateAttribution",
    label: "Date d'attribution",
    type: "date",
    required: true,
  },
  {
    name: "endAttributionDate",
    label: "Date de fin d'attribution",
    type: "date",
    required: false,
  },
  {
    name: "dateRestitution",
    label: "Date de restitution",
    type: "date",
    required: false,
  },
];

export const carteFields: FormFieldType<IVehicleAffectation>[] = [
  {
    name: "fournisseurCarteCarburant",
    label: "Fournisseur carte carburant",
    type: "text",
    required: false,
    icon: faBuilding,
  },
  {
    name: "numeroCarteCarburant",
    label: "Numéro de carte carburant",
    type: "text",
    required: false,
    icon: faHashtag,
  },
  {
    name: "numeroLicence",
    label: "Numéro de licence",
    type: "text",
    required: false,
    icon: faHashtag,
  },
  {
    name: "fleet",
    label: "Fleet",
    type: "text",
    required: false,
    icon: faTruck,
  },
  {
    name: "transcolaire",
    label: "Transcolaire",
    type: "text",
    required: false,
    icon: faBus,
  },
  {
    name: "monday",
    label: "Monday",
    type: "text",
    required: false,
    icon: faCheckCircle,
  },
  {
    name: "dateRestitution",
    label: "Date de restitution",
    type: "date",
    required: false,
  },
];