"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import TableActionColumn from "@/shared/components/table/table-action-column"
import { useTheme } from "@mui/material/styles"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import { dateFormat, formatDate } from "@/utils/format-time"
import { ContratStyledRow} from "@/shared/sections/contract/styles"
import { IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation"
import { PersonalTypeChip } from '@/shared/theme/css';

type Props = {
  handleEdit: (affectation: IVehicleAffectation) => void
  handleDetails: (affectation: IVehicleAffectation) => void
  handleCopy: (affectation: IVehicleAffectation) => void
  selected: boolean
  dense: boolean
  row: IVehicleAffectation
  onSelectRow: VoidFunction
  columns: TableColumn[]
  onStatusChange: (row: IVehicleAffectation, newStatus: string, field: keyof IVehicleAffectation) => void;
}

const TOOLTIP_TITLES = {
  edit: "Modifier affectation",
  active: "Affectation active",
  inactive: "Affectation inactive",
}

export default function AffectationTableRow({
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
  onStatusChange
}: Props) {
  const theme = useTheme()

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "dateAttribution":
      case "endAttributionDate":
      case "dateRestitution":
        return formatDate(value, dateFormat.isoDate)
        case "personnelType":
          return (
            <PersonalTypeChip
              label={value}
              status={value}
              theme={theme}
            />
          );              
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover selected={selected} style={{ cursor: "pointer" }}>
      {columns
        .filter((column) => column.id !== "isActive")
        .map((column: any, index: number) => (
          <TableCell
            onDoubleClick={() => handleDetails(row)}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap",
              py: column.id === "isActive" ? 0 : "inherit" }}
          >
            {renderCellContent(column.id, row[column.id as keyof IVehicleAffectation])}
          </TableCell>
        ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEdit(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}

