'use client';
import React, { useState } from 'react';
import {
  Box,
  Typography,
  Card,
  CardContent,
  Switch,
  Divider,
  Slider,
  Button,
  Stack,
} from '@mui/material';
import {
  FUEL_ANOMALY_INITIAL_DATA,
  FuelAnomalyConfig,
} from '@/shared/types/flottes/anomaly-config';
import { fuelAnomaliesFields } from '@/shared/_mock/flottes/_anomaly-config';

export default function FuelAnomalyConfigView() {
  const [config, setConfig] = useState<FuelAnomalyConfig>(FUEL_ANOMALY_INITIAL_DATA);
  const [stopDelay, setStopDelay] = useState<number>(Number(config.stopDetectionDelay) || 36);

  const handleChange = (field: keyof FuelAnomalyConfig, value: any) => {
    setConfig((prev) => ({ ...prev, [field]: value }));
  };

  const handleStopDelayChange = (_: Event, value: number | number[]) => {
    const newValue = Array.isArray(value) ? value[0] : value;
    setStopDelay(newValue);
    handleChange('stopDetectionDelay', newValue.toString());
  };

  const handleSave = () => {
    console.log('Configuration enregistrée :', config);
  };

  return (
    <Box sx={{ p: 2 }}>
      <Typography variant="h6" fontWeight="bold" gutterBottom>
        Configuration Carburant
      </Typography>
      <Card sx={{ mb: 3, borderRadius: 2, backgroundColor: 'rgba(124, 77, 255, 0.05)' }}>
        <CardContent>
          <Typography variant="h6" fontWeight="bold" gutterBottom>
            Paramètres Véhicule
          </Typography>

          <Stack direction="row" justifyContent="space-between" alignItems="center" sx={{ mb: 1 }}>
            <Box>
              <Typography fontWeight="medium">Vérification véhicule en arrêt</Typography>
              <Typography variant="body2" color="text.secondary">
                Vérifier l’utilisation de la carte quand le véhicule est en congé/arrêt
              </Typography>
            </Box>
            <Switch
              checked={config.vehicleStopVerification}
              onChange={(e) => handleChange('vehicleStopVerification', e.target.checked)}
              color="secondary"
            />
          </Stack>

          <Divider sx={{ my: 2 }} />

          <Box>
            <Typography fontWeight="medium">Délai détection arrêt</Typography>
            <Typography variant="body2" color="text.secondary" mb={1}>
              Délai après lequel un véhicule est considéré en arrêt
            </Typography>

            <Box display="flex" alignItems="center" justifyContent="space-between">
              <Slider
                value={stopDelay}
                onChange={handleStopDelayChange}
                min={1}
                max={72}
                step={1}
                sx={{ flexGrow: 1, mx: 1 }}
              />
              <Typography
                color="secondary"
                fontWeight="bold"
                sx={{ width: '70px', textAlign: 'right' }}
              >
                {stopDelay} H
              </Typography>
            </Box>

            <Box display="flex" justifyContent="space-between" mt={-1} mr={8}>
              <Typography variant="caption">1h</Typography>
              <Typography variant="caption">36h</Typography>
              <Typography variant="caption">72h</Typography>
            </Box>
          </Box>
        </CardContent>
      </Card>

      <Card sx={{ borderRadius: 2, backgroundColor: 'rgba(77, 171, 255, 0.05)' }}>
        <CardContent>
          <Typography variant="h6" fontWeight="bold" gutterBottom>
            Anomalies Carburant
          </Typography>

          {fuelAnomaliesFields.map((item, index) => (
            <Box
              key={index}
              sx={{
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'space-between',
                py: 1.2,
                borderBottom: index !== 8 ? '1px solid #e5eaf2' : 'none',
              }}
            >
              <Box>
                <Typography fontWeight="medium">{item.label}</Typography>
                <Typography variant="body2" color="text.secondary">
                  {item.sub}
                </Typography>
              </Box>
              <Switch
                checked={config[item.field as keyof FuelAnomalyConfig] as boolean}
                onChange={(e) =>
                  handleChange(item.field as keyof FuelAnomalyConfig, e.target.checked)
                }
                color="secondary"
              />
            </Box>
          ))}
        </CardContent>
      </Card>

      <Box sx={{ mt: 3, textAlign: 'right' }}>
        <Button
          variant="contained"
          color="primary"
          onClick={handleSave}
          sx={{ textTransform: 'none', borderRadius: 2 }}
        >
          Sauvegarder les modifications
        </Button>
      </Box>
    </Box>
  );
}
