'use client';
import React, { useState } from 'react';
import { Box, Card, CardContent, Stack, Switch, Typography, Button } from '@mui/material';
import {
  MileageAnomalyConfig,
  MILEAGE_ANOMALY_INITIAL_DATA,
} from '@/shared/types/flottes/anomaly-config';
import { mileageAnomaliesFields } from '@/shared/_mock/flottes/_anomaly-config';

export default function MileageAnomalyConfigView() {
  const [config, setConfig] = useState<MileageAnomalyConfig>(MILEAGE_ANOMALY_INITIAL_DATA);

  const handleChange = (field: keyof MileageAnomalyConfig, value: boolean) => {
    setConfig((prev) => ({ ...prev, [field]: value }));
  };

  const handleSave = () => {
    console.log('Configuration enregistrée :', config);
  };

  return (
    <Box sx={{ p: 2 }}>
      <Card sx={{ borderRadius: 2, backgroundColor: 'rgba(77, 171, 255, 0.05)' }}>
        <CardContent>
          <Typography variant="h6" fontWeight="bold" gutterBottom>
            Configuration Kilométrage
          </Typography>

          {mileageAnomaliesFields.map((item, index) => (
            <Box
              key={index}
              sx={{
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'space-between',
                py: 1.2,
                borderBottom:
                  index !== mileageAnomaliesFields.length - 1 ? '1px solid #e5eaf2' : 'none',
              }}
            >
              <Box>
                <Typography fontWeight="medium">{item.label}</Typography>
                <Typography variant="body2" color="text.secondary">
                  {item.sub}
                </Typography>
              </Box>
              <Switch
                checked={config[item.field as keyof MileageAnomalyConfig] as boolean}
                onChange={(e) =>
                  handleChange(item.field as keyof MileageAnomalyConfig, e.target.checked)
                }
                color="secondary"
              />
            </Box>
          ))}
        </CardContent>
      </Card>

      <Box sx={{ mt: 3, textAlign: 'right' }}>
        <Button
          variant="contained"
          color="primary"
          onClick={handleSave}
          sx={{ textTransform: 'none', borderRadius: 2 }}
        >
          Sauvegarder les modifications
        </Button>
      </Box>
    </Box>
  );
}
