'use client';
import TableCell from '@mui/material/TableCell';
import type { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { ContratStyledRow } from '@/shared/sections/contract/styles';
import { _FUEL_TYPE_OPTIONS } from '@/shared/_mock/flottes/_fuelFees';
import { IVehicleList } from '@/shared/types/flottes/anomaly-config';

type Props = {
  handleEditFuelFee: (fuelFee: IVehicleList) => void;
  handleDetailsFuelFee: (fuelFee: IVehicleList) => void;
  handleCopyFuelFee: (fuelFee: IVehicleList) => void;
  selected: boolean;
  row: IVehicleList;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

export default function VehicleListTableRow({
  row,
  handleEditFuelFee,
  handleDetailsFuelFee,
  handleCopyFuelFee,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'date':
        return formatDate(value, dateFormat.isoDate);
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns.map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsFuelFee(row)}
          key={column.id}
          align={column.align}
        >
          {renderCellContent(column.id, row[column.id as keyof IVehicleList])}
        </TableCell>
      ))}
    </ContratStyledRow>
  );
}
