'use client';
import { type TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { IVehicleList } from '@/shared/types/flottes/anomaly-config';
import { INITIAL_VEHICLE_LIST } from '@/shared/_mock/flottes/_anomaly-config';

const fuelCardImportHistoryConfig: TabConfig<IVehicleList> = {
  type: 'frais carburant',
  listTitle: 'Liste des véhicules',
  newItemTitle: 'Nouveau import de cartes carburant',
  initialData: INITIAL_VEHICLE_LIST,
  getItemCode: (fuelCardImport) => fuelCardImport.id,
};

export function useVehicleListTabs() {
  return useTabsManager<IVehicleList>(fuelCardImportHistoryConfig);
}
