'use client';

import React, { useState } from 'react';
import { Box, Tabs, Tab } from '@mui/material';
import { faCar, faGasPump, faRuler } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import FormContainer from '@/layouts/form/form-container';
import FuelAnomalyConfigView from '../components/fuel-anomaly-config';
import MileageAnomalyConfigView from '../components/mileage-anomaly-config';
import VehicleAnomalyConfigView from '../components/vehicle-anomaly-config';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

export default function AnomalyConfigView() {
  const [selectedTab, setSelectedTab] = useState(0);

  const handleChange = (_: React.SyntheticEvent, newValue: number) => {
    setSelectedTab(newValue);
  };

  return (
    <FormContainer titre="Configuration des Anomalies">
      <Box
        sx={{
          borderBottom: 1,
          borderColor: 'divider',
          backgroundColor: '#f8fbff',
          borderRadius: 2,
        }}
      >
        <Tabs
          value={selectedTab}
          onChange={handleChange}
          aria-label="Configuration des anomalies"
          textColor="primary"
          indicatorColor="primary"
          variant="fullWidth"
        >
          <Tab
            icon={<FontAwesomeIcon icon={faGasPump} color="#e53935" />}
            iconPosition="start"
            label="Configuration Carburant"
            sx={{
              fontWeight: selectedTab === 0 ? 'bold' : 'normal',
              fontFamily: "'Poppins', sans-serif",
            }}
          />
          <Tab
            icon={<FontAwesomeIcon icon={faRuler} color="#6f129bff" />}
            iconPosition="start"
            label="Configuration Kilométrage"
            sx={{
              fontWeight: selectedTab === 1 ? 'bold' : 'normal',
              fontFamily: "'Poppins', sans-serif",
            }}
          />
          <Tab
            icon={<FontAwesomeIcon icon={faCar} color="#8d0eb4ff" />}
            iconPosition="start"
            label="Configuration Véhicule"
            sx={{
              fontWeight: selectedTab === 2 ? 'bold' : 'normal',
              fontFamily: "'Poppins', sans-serif",
            }}
          />
        </Tabs>
      </Box>

      <Box sx={{ mt: 3 }}>
        <ConditionalComponent isValid={selectedTab === 0} defaultComponent={null}>
          <FuelAnomalyConfigView />
        </ConditionalComponent>

        <ConditionalComponent isValid={selectedTab === 1} defaultComponent={null}>
          <MileageAnomalyConfigView />
        </ConditionalComponent>

        <ConditionalComponent isValid={selectedTab === 2} defaultComponent={null}>
          <VehicleAnomalyConfigView />
        </ConditionalComponent>
      </Box>
    </FormContainer>
  );
}
