'use client';

import { Button, Checkbox, Divider, FormControl, FormControlLabel, List, ListItem, ListItemIcon, ListItemText, Radio, RadioGroup, Typography } from '@mui/material';
import type { IGeolocData } from '@/shared/types/flottes/mileage';
import FontAwesome from '@/shared/components/fontawesome';
import { faCalendarDays, faCircleExclamation, faTag, faMapMarkerAlt, faInfoCircle } from '@fortawesome/free-solid-svg-icons';
import { ScrollBox, StyledTextField } from '@/shared/theme/css';
import CustomDrawer from '@/shared/components/drawer/custom-drawer';
import { useEffect, useState } from 'react';
import { mockedGeolocData } from '@/shared/_mock/flottes/_mileage';
import { Consumption, } from '@/shared/types/flottes/consumption';
import { Box } from '@mui/system';
import { dateFormat, formatDate } from '@/utils/format-time';


const DRAWER_WIDTH = 450;

type Props = {
  isOpen: any;
  onClose: () => void;
  rowData: Consumption;
};

export default function AbnormalConsumptionDrawer({ isOpen, onClose, rowData }: Props) {
  const [reason, setReason] = useState(rowData.causes);
  const [value, setValue] = useState('Non Justifié');
  const {date,product,tanker,fuelCardNumber,transactionAddress,consumptionDetails}=rowData;
  const [sendMail, setSendMail] = useState(false);
  const [description, setDescription] = useState('');

  const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setValue((event.target as HTMLInputElement).value);
  };

  const handleClose = () => {
    onClose();
  };

  const handleCheckboxChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setSendMail(event.target.checked);
  };

  const handleSendMessage = (event: React.FormEvent<HTMLFormElement>) => {
    event.preventDefault();
    console.log('Message sent');
    if (sendMail) {
      console.log('Mail sent');
    }
    handleClose();
  };

  const handleDescriptionChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
    setDescription(event.target.value);
  };
  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen.value} onClose={onClose}>
      <Typography
        variant="h5"
        sx={{
          p: 2,
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {rowData.employe.firstName} {rowData.employe.lastName}
      </Typography>

      <ScrollBox sx={{ maxHeight: 'calc(100vh - 80px)' }}>
        <Box sx={{ p: 1 }}>
          <Divider />
          <List>
            <ListItem>
              <ListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faCalendarDays} width={18} />
              </ListItemIcon>
              <ListItemText
                primary="Consommation"
                secondary={formatDate(date, dateFormat.isoDate)}
              />
            </ListItem>

            <ListItem>
              <ListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faTag} width={18} />
              </ListItemIcon>
              <ListItemText primary="Produit" secondary={product} />
            </ListItem>
            <ListItem>
              <ListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faCalendarDays} width={18} />
              </ListItemIcon>
              <ListItemText primary="Carte:" secondary={`${fuelCardNumber} (${tanker})`} />
            </ListItem>
            
            <ListItem>
              <ListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faMapMarkerAlt} width={18} />
              </ListItemIcon>
              <ListItemText 
                primary="Adresse de transaction" 
                secondary={transactionAddress || "Non spécifiée"} 
              />
            </ListItem>

            <ListItem>
              <ListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faInfoCircle} width={18} />
              </ListItemIcon>
              <ListItemText 
                primary="Détails de consommation" 
                secondary={consumptionDetails || "Aucun détail disponible"} 
              />
            </ListItem>
            
            <Divider variant="inset" component="li" />

            <ListItem>
              <ListItemIcon>
                <FontAwesome icon={faCircleExclamation} width={18} sx={{ color: 'error.main' }} />
              </ListItemIcon>
              <ListItemText
                primary={
                  <Typography variant="subtitle2" sx={{ color: 'red' }}>
                    {reason}
                  </Typography>
                }
              />
            </ListItem>
            <Divider variant="inset" component="li" />
            <Box sx={{ mt: 2 }}>
              <FormControl>
                <RadioGroup
                  aria-labelledby="demo-controlled-radio-buttons-group"
                  name="controlled-radio-buttons-group"
                  value={value}
                  onChange={handleChange}
                  row
                >
                  <FormControlLabel value="justifié" control={<Radio />} label="Justifié" />
                  <FormControlLabel value="non_justifié" control={<Radio />} label="Non justifié" />
                </RadioGroup>
              </FormControl>

              <Box
                component="form"
                onSubmit={handleSendMessage}
                noValidate
                autoComplete="off"
                sx={{
                  mt: 2,
                  display: 'flex',
                  flexDirection: 'column',
                }}
              >
                <StyledTextField
                  autoFocus
                  margin="dense"
                  id="description"
                  label="Observation"
                  multiline
                  rows={3}
                  fullWidth
                  onChange={handleDescriptionChange}
                  variant="outlined"
                  required
                />
                <FormControlLabel
                  control={<Checkbox checked={sendMail} onChange={handleCheckboxChange} />}
                  label="Envoyer un mail"
                />
                <Box sx={{ mt: 1, display: 'flex', justifyContent: 'flex-end' }}>
                  <Button type="submit" variant="contained" color="primary">
                    Envoyer
                  </Button>
                </Box>
              </Box>
            </Box>
          </List>
        </Box>
      </ScrollBox>
    </CustomDrawer>
  );
}
