"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { Consumption } from "@/shared/types/flottes/consumption"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

interface FuelConsumptionTableRowProps {
  row: Consumption
  selected: boolean
  onSelectRow: () => void
  onRowDoubleClick: () => void
  columns: TableColumn[]
  dense: boolean
}

export default function AbnormalConsumptionTableRow({
  row,
  selected,
  onSelectRow,
  onRowDoubleClick,
  columns,
  dense,
}: FuelConsumptionTableRowProps) {

  const renderCellContent = (column: TableColumn) => {
    switch (column.id) {
      case "cardNumber":
        return row.cardNumber || row.fuelCardNumber
      case "driverName":
        return row.driverName || `${row.employe.firstName} ${row.employe.lastName}`
      case "transactionDate":
        return row.transactionDate || row.date
      case "vehicle":
        return row.vehicle || row.employe.carRegistration || row.employe.vehicule
      case "tanker":
        return row.tanker
      case "fuelType":
        return row.fuelType || row.product
      case "amount":
        return row.amount || `${row.totalAmount.toFixed(2)} €`
      case "quantity":
        return `${row.quantity.toFixed(2)} L`
      case "telephone":
        return row.telephone || row.employe.phone
      case "department":
        return row.department || row.employe.department
      // Legacy column support for backward compatibility
      case "firstName":
        return row.employe.firstName
      case "lastName":
        return row.employe.lastName
      case "vehicule":
        return row.employe.carRegistration || row.employe.vehicule
      case "date":
        return row.date
      case "phone":
        return row.employe.phone
      case "totalAmount":
        return `${row.totalAmount.toFixed(2)} €`
      case "fuelVolume":
        return `${row.employe.fuelVolume.toFixed(2)} L`
      default:
        return ""
    }
  }
  return (
    <>
      <ContratStyledRow hover style={{ cursor: "pointer" }}>
        {columns.map((column: any, index: number) => (
          <TableCell
            onDoubleClick={onRowDoubleClick}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap", py: dense ? 1 : 2, ...(index === 0 && {position: "relative"}), }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.product) }}
              />
            </ConditionalComponent>
          {renderCellContent(column)}
          </TableCell>
        ))}
      </ContratStyledRow>
    </>
  )
}

