"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import type { IMileage } from "@/shared/types/flottes/mileage"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { dateFormat, formatDate } from "@/utils/format-time"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  selected: boolean
  row: IMileage
  onSelectRow: VoidFunction
  columns: TableColumn[]
  onRowDoubleClick: () => void
  dense?:boolean
  }

export default function MileageTableRow({
  row,
  selected,
  onSelectRow,
  columns,
  onRowDoubleClick,
  dense
}: Props) {

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "startDate":
      case "endDate":
        return formatDate(value, dateFormat.isoDate)
      case "anormalKm":
        return value + " km"
      default:
        return value
    }
  }
  return (
    <>
      <ContratStyledRow hover style={{ cursor: "pointer" }}>
        {columns.map((column: any, index: number) => (
          <TableCell
            onDoubleClick={onRowDoubleClick}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap", py: dense ? 1 : 2, ...(index === 0 && {position: "relative"}), }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.car) }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof IMileage])}
          </TableCell>
        ))}
      </ContratStyledRow>
    </>
  )
}

