import { Chip } from '@mui/material';
import { styled } from '@mui/system';

export const FleetDocumentStatusChip = styled(Chip)(({ type }: { type: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(type === 'contrat_location' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(type === 'assurance' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(type === 'carte_grise' && {
      backgroundColor: '#E1F5FE',
      color: '#0288D1',
    }),
    ...(type === 'controle_technique' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(type === 'revision' && {
      backgroundColor: '#F3E5F5',
      color: '#7B1FA2',
    }),
    ...(type === 'autre' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
}));

export const FleetDocumentCategoryChip = styled(Chip)(({ category }: { category: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(category === 'VEHICULE' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(category === 'MAINTENANCE' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(category === 'LEGAL' && {
      backgroundColor: '#E1F5FE',
      color: '#0288D1',
    }),
  },
}));

export const FleetStatusChip = styled(Chip)(({ status }: { status: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(status === 'valide' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(status === 'expire' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'a_renouveler' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(status === 'en_attente' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
})); 