import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_REPAIRS_DATA } from '@/shared/_mock/flottes/_intervention';
import { IIntervention } from '@/shared/types/flottes/intervention';

const iInterventionConfig: TabConfig<IIntervention> = {
  type: 'Réparation',
  listTitle: 'Liste des réparations',
  newItemTitle: 'Nouvelle Réparation',
  initialData: INITIAL_REPAIRS_DATA,
  getItemCode: (inter) => inter.vehiculeConcerne,
};

export function useInterventionTabs() {
  return useTabsManager<IIntervention>(iInterventionConfig);
}

