import type { IIntervention } from "@/shared/types/flottes/intervention"
import type { FormFieldType } from "@/shared/types/common"
import {
  faHashtag,
  faNoteSticky,
  faTachometerAltAverage,
  faEuro,
  faWrench,
  faFileInvoice,
  faMap,
  faScrewdriver,
} from "@fortawesome/free-solid-svg-icons"
import { _OPTION_STATUT, } from "@/shared/_mock/flottes/_intervention"
import { _BINARY_Qst } from "@/shared/_mock/_trajets"
import { Option } from "@/shared/sections/circuit/utils/form-fields-circuit"
import { IMMATRICULATIONS } from "@/shared/_mock"
import { NOMS_FOURNISSEUR } from "@/shared/_mock/flottes/_supplier"

export const interventionformFields = (interventionsOptions: Option[]): FormFieldType<IIntervention>[] => [
  // Informations du véhicule
  {
    name: "vehiculeConcerne",
    label: "Véhicule concerné",
    type: "select",
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Choisissez une véhicule",
  },
  {
    name: "garage",
    label: "Garage",
    type: "select",
    placeholder: "Choisissez un garage",
  },
  {
    name: "immatriculation",
    label: "Immatriculation",
    type: "select",
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Plaque d'immatriculation du véhicule",
  },

  // Détails de l'intervention
  {
    name: "fournisseur",
    label: "Fournisseur",
    type: "select",
    placeholder: "Choisissez un fournisseur",
    options: NOMS_FOURNISSEUR.map((supplier) => ({
      label: supplier,
      value: supplier,
    })),
  },
  {
    name: "intervention",
    label: "Intervention",
    type: "select",
    placeholder: "Sélectionnez un type",
    options: interventionsOptions,
    required: true,
  },
  {
    name: "typeIntervention",
    label: "Type d'intervention",
    type: "text",
    icon: faWrench,
    required: true,
  },
  {
    name: "dateIntervention",
    label: "Date de Réparation",
    type: "date",
    placeholder: "Sélectionnez la date de l'intervention",
  },
  {
    name: "statut",
    label: "Statut",
    type: "select",
    placeholder: "Sélectionnez un statut",
    options: _OPTION_STATUT,
  },
  {
    name: "kilometrageReleve",
    label: "Kilométrage relevé",
    type: "text",
    placeholder: "Entrez le kilométrage",
    icon: faTachometerAltAverage,
  },
  {
    name: "montantDevis",
    label: "Devis",
    type: "text",
    placeholder: "Entrez ou choisissez un montant",
    icon: faEuro,
  },

  // Informations financières
  {
    name: "coutTTC",
    label: "Coût TTC",
    type: "text",
    placeholder: "Entrez le coût TTC",
    icon: faHashtag,
  },
  {
    name: "coutHT",
    label: "Coût HT",
    type: "text",
    placeholder: "Entrez le coût HT",
    icon: faHashtag,
  },
  {
    name: "acceptationDevis",
    label: "Accepté",
    type: "select",
    placeholder: "Sélectionnez une option",
    options: _BINARY_Qst,
  },
  {
    name: "numeroFacture",
    label: "Numéro de facture",
    type: "text",
    placeholder: "Référence de la facture",
    icon: faFileInvoice,
  },
  {
    name: "dateFacture",
    label: "Date facture",
    type: "date",
    placeholder: "Date d'émission de la facture",
  },
  {
    name: "departement",
    label: "Département",
    type: "select",
    placeholder: "Sélectionnez un département",
  },
  // Planification
  {
    name: "dateDebutImmobilisation",
    label: "Début immobilisation",
    type: "date",
    placeholder: "Date de début d'immobilisation",
  },
  {
    name: "dateFinImmobilisation",
    label: "Fin immobilisation",
    type: "date",
    placeholder: "Date de fin d'immobilisation",
  },

  // Détails techniques
  {
    name: "pieces",
    label: "Pièce",
    type: "text",
    placeholder: "Pièces remplacées ou réparées",
    icon: faScrewdriver,
  },
  {
    name: "quantitePieces",
    label: "Quantité",
    type: "number",
    placeholder: "Nombre de pièces utilisées",
    icon: faHashtag,
  },
  {
    name: "observations",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
];

