import * as yup from 'yup'

export const interventionSchema = yup.object().shape({
  vehiculeConcerne: yup.string().required('Le véhicule est requis'),
  intervention: yup.string().required('L\'intervention est requise'),
  typeIntervention: yup.string()
    .required('Le type d\'intervention est requis'),
  dateIntervention: yup.date().required('La date d\'intervention est requise'),
  statut: yup.string().required('Le statut est requis'),
  kilometrageReleve: yup.string(),
  montantDevis: yup.string(),
  coutTTC: yup.string(),
  coutHT: yup.string(),
  acceptationDevis: yup.string(),
  client: yup.string().required('Le client est requis'),
  societe: yup.string(),
  reparateur: yup.string(),
  fournisseur: yup.string(),
  dateDebutImmobilisation: yup.date().nullable(),
  dateFinImmobilisation: yup.date().nullable(),
  garantie: yup.string(),
  factureRecue: yup.string(),
  conducteurPrevenu: yup.string(),
  le: yup.date().nullable(),
  observations: yup.string(),
}) 