"use client"

import type React from "react"
import { Box, Grid } from "@mui/material"
import type { TableColumn , FormFieldType, ModeType } from "@/shared/types/common"
import type { VehicleRepairRequest } from "@/shared/types/fleet-management/vehicle-repair"
import FormActions from "@/shared/components/form/form-actions"

interface VehicleRepairTabProps {
  renderField: (field: FormFieldType<VehicleRepairRequest>) => React.ReactNode
  repairFields: FormFieldType<VehicleRepairRequest>[]
  isReadOnly: boolean
  formik: any
  onEdit: (updatedRepair: VehicleRepairRequest) => void
  onSave: () => void
  onClose: (isSaved: boolean) => void
  tableHead: TableColumn[]
  mode: ModeType
  setHasUnsavedChanges?: (value: boolean) => void
}

export default function VehicleRepairTab({
  renderField,
  repairFields,
  isReadOnly,
  formik,
  onEdit,
  onSave,
  onClose,
  tableHead,
  mode,
  setHasUnsavedChanges,
}: VehicleRepairTabProps) {
  return (
    <Box sx={{ p: 3 }}>
      <Grid container spacing={3}>
        {repairFields.map((field) => (
          <Grid item xs={12} md={6} key={field.name}>
            {renderField(field)}
          </Grid>
        ))}
      </Grid>

      <FormActions
        mode={mode}
        onEdit={() => onEdit(formik.values)}
        onSave={onSave}
        onCancel={() => onClose(false)}
        readOnly={formik.isValid && formik.dirty}
      />
    </Box>
  )
}
