import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { type VehicleRepairListResponse, type VehicleRepairRequest, RepairStatus } from "@/shared/types/fleet-management/vehicle-repair"

const INITIAL_VEHICLE_REPAIR_DATA: VehicleRepairListResponse = {
  id: "",
  vehicleId: "",
  vehicleName:"",
  licensePlate: "",
  repairDate: "",
  mileage: 0,
  repairStatus: RepairStatus.PENDING,
  serviceType: undefined as any,
  garageName: "",
  departmentId: "",
  parts: "",
  quantity: 0,
  quoteAmount: 0,
  costHT: 0,
  costTTC: 0,
  accepted: false,
  invoiceNumber: "",
  invoiceDate: "",
  immobilizationStart: "",
  immobilizationEnd: "",
  observation: "",
  serviceProviderId: "",
  serviceProviderName: "",
  interventionId: "",
  interventionName: "",
  active: true,
}

const vehicleRepairConfig: TabConfig<VehicleRepairListResponse | VehicleRepairRequest> = {
  type: "réparation véhicule",
  listTitle: "Liste des réparations",
  newItemTitle: "Nouvelle réparation",
  initialData: INITIAL_VEHICLE_REPAIR_DATA,
  getItemCode: (repair) => repair.licensePlate,
}

export function useVehicleRepairTabs() {
  return useTabsManager<VehicleRepairListResponse | VehicleRepairRequest>(vehicleRepairConfig)
}
