import type { FormFieldType } from "@/shared/types/common"
import type { VehicleRepairRequest } from "@/shared/types/fleet-management/vehicle-repair"
import { faHashtag, faNoteSticky, faTag, faCalendar, faWrench, faMoneyBill } from "@fortawesome/free-solid-svg-icons"

export const _VEHICLE_REPAIR_DOCUMENT_TYPES = [
  { value: "devis", label: "Devis : Estimation des coûts" },
  { value: "facture", label: "Facture : Facture de réparation" },
  { value: "rapport", label: "Rapport : Rapport d'intervention" },
  { value: "photos", label: "Photos : Photos avant/après" },
  { value: "garantie", label: "Garantie : Certificat de garantie" },
  { value: "autres", label: "Autres documents : Documents divers" },
]

export const vehicleRepairFormFields = (
  vehicleOptions: { value: string; label: string }[],
  serviceProviderOptions: { value: string; label: string }[],
  interventionOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[],
): FormFieldType<VehicleRepairRequest>[] => [
  {
    name: "vehicleId",
    label: "Véhicule",
    type: "select",
    options: vehicleOptions,
    placeholder: "Choisissez un véhicule",
    required: true,
  },
  {
    name: "departmentId",
    label: "Département",
    type: "select",
    options: departmentOptions,
    placeholder: "Choisissez un département",
    required: true,
  },
  {
    name: "licensePlate",
    label: "Immatriculation",
    type: "text",
    placeholder: "AAAA 0000 000 0000",
    icon: faTag,
    required: true,
  },
  {
    name: "mileage",
    label: "Kilométrage",
    type: "number",
    icon: faHashtag,
    placeholder: "0",
    required: true,
  },
  {
    name: "garageName",
    label: "Nom du garage",
    type: "text",
    placeholder: "Nom du garage",
    icon: faWrench,
  },
  {
    name: "serviceProviderId",
    label: "Prestataire de service",
    type: "select",
    options: serviceProviderOptions,
    placeholder: "Choisissez un prestataire",
  },
  {
    name: "interventionId",
    label: "Type d'intervention",
    type: "select",
    options: interventionOptions,
    placeholder: "Choisissez une intervention",
  },
  {
    name: "parts",
    label: "Pièces",
    type: "textarea",
    placeholder: "Liste des pièces remplacées",
    icon: faWrench,
  },
  {
    name: "quantity",
    label: "Quantité",
    type: "number",
    icon: faHashtag,
    placeholder: "0",
  },
  {
    name: "quoteAmount",
    label: "Montant du devis (€)",
    type: "number",
    icon: faMoneyBill,
    placeholder: "0.00",
  },
  {
    name: "costTTC",
    label: "Montant TTC (€)",
    type: "number",
    icon: faMoneyBill,
    placeholder: "0.00",
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
]
