import * as yup from "yup"

export const vehicleRepairSchema = yup.object().shape({
  vehicleId: yup.string().required("Le véhicule est requis"),
  licensePlate: yup.string().required("L'immatriculation est requise"),
  repairDate: yup.date().required("La date de réparation est requise"),
  mileage: yup.number().min(0, "Le kilométrage doit être positif").required("Le kilométrage est requis"),
  garageName: yup.string(),
  parts: yup.string(),
  quantity: yup.number().min(0, "La quantité doit être positive"),
  quoteAmount: yup.number().min(0, "Le montant du devis doit être positif"),
  observation: yup.string(),
  serviceProviderId: yup.string(),
  interventionId: yup.string(),
})
